#include <cstdio>
#include <hal/drivers/flash.h>
#include <hal/devices.h>

int cmd_coefficient(int argc, char *argv[])
{
	if (argc != 2)
	{
		printf("%s: error, syntax: ADDRESS %s COEFFICIENT\n\n", argv[0], argv[0]);
	}
	else
	{
		float coefficient = -1;
		sscanf(argv[1], "%f", &coefficient);

		if (coefficient <= configure_file.max_temp_coef && coefficient >= configure_file.min_temp_coef)
		{
			flash_file * p_flash_file;

			decltype(p_flash_file->temp_coef) temp_coef = coefficient;

			fseek(p_flash, (int) (&p_flash_file->temp_coef) - (int) (p_flash_file), SEEK_SET);
			fwrite(&temp_coef, sizeof(flash_file::temp_coef), 1, p_flash);
			fflush(p_flash);

			printf("%s: the temperature coefficient is set to: %f%%/'C\n\n", argv[0], coefficient);
		}
		else
		{
			printf("%s: error, temperature coefficient input: %s is not in range: %f~%f\n\n", argv[0], argv[1],
			    configure_file.min_temp_coef, configure_file.max_temp_coef);
		}
	}

	fflush(stdout);
}
